#include "MTTXMBViewer.h"
#include "MTFileList.h"
#include "MTUtilities.h"
#include "MTExceptions.h"
#include "MTApplication.h"

MTInfoWindowDataTemplate	MTTXMBViewer::kTXMBTemplate =
{
	6,
	{
		{	"ID" },
		{	"Version" },
		{	"Unknown" },
		{	"Unknown" },
		{	"Width" },
		{	"Height" }
	}
};

struct MTTXMBFormat
{
	UInt32	id;
	UInt32	version;
	UInt16	filler1[4];
	UInt32	unknown1;
	UInt32	unknown2;
	UInt16	width;
	UInt16	height;
	UInt32	numEntries;
	UInt32	entries[0];
};

MTTXMBViewer::MTTXMBViewer()
{
	totalWidth = totalHeight = depth = 0;
}

MTTXMBViewer::~MTTXMBViewer()
{
	
}

void MTTXMBViewer::ParseData(UInt8 * buf, UInt32 bufSize)
{
	MTTXMBFormat	* format;
	MTFileList		* fileList = GetOwningFileList();
	
	if(bufSize < sizeof(MTTXMBFormat))
		throw MTUnsupportedException("Unsupported data structure");
	
	format = (MTTXMBFormat *)buf;
	
	SWAP32(format->id);
	SWAP32(format->version);
	SWAP32(format->unknown1);
	SWAP32(format->unknown2);
	SWAP16(format->width);
	SWAP16(format->height);
	SWAP32(format->numEntries);
	
	for(UInt32 i = 0; i < format->numEntries; i++)
	{
		SWAP32(format->entries[i]);
	}
	
	id =		format->id;
	version =	format->version;
	unknown1 =	format->unknown1;
	unknown2 =	format->unknown2;
	width =		format->width;
	height =	format->height;
	
	entries.resize(format->numEntries);
	for(UInt32 i = 0; i < format->numEntries; i++)
	{
		entries[i].id = format->entries[i];
		entries[i].handler.AttachFileList(fileList);
		
		UInt32	idx = fileList->theFile->LookupIdxFromID(entries[i].id);
		UInt8	* buf = fileList->theFile->LoadFileByIdx(idx);
		
		entries[i].handler.ParseData(buf, fileList->theFile->fileList[idx].size);
		
		DisposePtr((Ptr)buf);
	}
	
	totalWidth = 0;
	for(UInt32 x = 0; x < width; x++)
		totalWidth += entries[x].handler.width;
	
	totalHeight = 0;
	for(UInt32 y = 0; y < height; y++)
		totalHeight += entries[y * width].handler.height;
	
	depth = entries[0].handler.depth;
	
	DisposePtr((Ptr)buf);
}

void MTTXMBViewer::GetWindowName(StringPtr theString)
{
	pstrcpy(theString, "\pTXMB");
}

void MTTXMBViewer::RecieveMessage(UInt32 messageType, UInt32 messageData)
{
	#pragma unused (messageData)
	
	switch(messageType)
	{
		case 'EXPT':
			ExportAsPicture(nil);
			break;
		
		case 'INFO':
			SpawnInfoWindow();
			break;
	}
}

UInt8 MTTXMBViewer::SupportsMessage(UInt32 messageType, UInt32 messageData)
{
	#pragma unused (messageData)
	
	switch(messageType)
	{
		case 'EXPT':
		case 'INFO':
			return 1;
	}
	
	return 0;
}

void MTTXMBViewer::DrawToPort(GWorldPtr theWorld)
{
	UInt32	xPos, yPos, idx;
	
	yPos = 0;
	idx = 0;
	
	for(UInt32 y = 0; y < height; y++)
	{
		xPos = 0;
		
		for(UInt32 x = 0; x < width; x++)
		{
			entries[idx].handler.DrawToPort(theWorld, xPos, yPos);
			
			xPos += entries[idx].handler.width;
			
			idx++;
		}
		
		yPos += entries[idx - 1].handler.height;
	}
}

void MTTXMBViewer::SpawnInfoWindow(void)
{
	MTInfoWindow	* window = new MTInfoWindow;
	char			text[256];
	
	window->SetOwner(this);
	window->AttachDataTemplate(&kTXMBTemplate);
	
	window->SetNumEntries(6 + entries.size());
	
	std::sprintf(text, "%.8X", id);
	window->SetEntryData(0, text, 0);
	
	std::sprintf(text, "%.8X", version);
	window->SetEntryData(1, text, 0);
	
	std::sprintf(text, "%.8X", unknown1);
	window->SetEntryData(2, text, 0);
	
	std::sprintf(text, "%.8X", unknown2);
	window->SetEntryData(3, text, 0);
	
	std::sprintf(text, "%d", width);
	window->SetEntryData(4, text, 0);
	
	std::sprintf(text, "%d", height);
	window->SetEntryData(5, text, 0);
	
	for(UInt32 i = 0; i < entries.size(); i++)
	{
		std::sprintf(text, "%.8X", entries[i].id);
		window->SetEntryData(6 + i, text, 0);
		window->SetEntryTitle(6 + i, "Image ID", 0);
	}
	
	window->SetOwnerName("TXMB");
	window->RecalculateListSpacing();
	
	gTheApp->AttachWindow(window);
	
	window->HandleUpdateEvent();
}